"""
Configuration URL principale du projet Core.
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static

# URLs principales
urlpatterns = [
    # 1. Interface d'administration Django
    path('admin/', admin.site.urls),

    # 2. Authentification API (Login/Logout pour l'interface web de DRF)
    path('api-auth/', include('rest_framework.urls')),

    # 3. Nos Endpoints API (Par domaine)
    
    
    # App: Sections 
    path('api/', include('apps.sections.urls')),

    # App: Pages 
    path('api/', include('apps.pages.urls')),

    # App: Content/Blog 
    path('api/', include('apps.content.urls')),

    # App: Navigation 
    path('api/navigation/', include('apps.navigation.urls')),

    # App: Settings 
    path('api/', include('apps.settings_site.urls')),

    # App: Chatbot 
    path('api/chatbot/', include('apps.chatbot.urls')),
]

# 4. Gestion des fichiers statiques et médias en mode Développement
# Indispensable pour voir les images uploadées dans l'admin ou via l'API
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)

    # Optionnel : Ajout de la toolbar debug si installée plus tard
    # import debug_toolbar
    # urlpatterns += [path('__debug__/', include(debug_toolbar.urls))]