from django.contrib import admin
from django.db import models
from django_json_widget.widgets import JSONEditorWidget
from .models import GlobalSettings

@admin.register(GlobalSettings)
class GlobalSettingsAdmin(admin.ModelAdmin):
    # On cache les boutons d'ajout/suppression pour sécuriser le singleton
    def has_add_permission(self, request):
        # Si une config existe déjà, on interdit d'en ajouter une autre
        return not GlobalSettings.objects.exists()

    def has_delete_permission(self, request, obj=None):
        # On interdit de supprimer la config principale
        return False

    # Organisation de l'interface
    fieldsets = (
        ('Identité', {
            'fields': ('site_name', 'site_description', 'logo_light', 'logo_dark', 'favicon')
        }),
        ('Contact & Réseaux', {
            'fields': ('contact_email', 'contact_phone', 'contact_address', 'social_links')
        }),
        ('Technique', {
            'fields': ('google_analytics_id', 'is_maintenance_mode')
        }),
    )

    formfield_overrides = {
        models.JSONField: {'widget': JSONEditorWidget},
    }