from rest_framework import viewsets, permissions
from .models import Section
# Note: On crée un Serializer basique pour le modèle DB, différent du Serializer de contenu JSON
from rest_framework import serializers

class SectionModelSerializer(serializers.ModelSerializer):
    class Meta:
        model = Section
        fields = ['id', 'type', 'data', 'order']

class SectionViewSet(viewsets.ReadOnlyModelViewSet):
    """
    Endpoint technique pour récupérer une section brute.
    Peu utilisé par le frontend Next.js (qui passe par Pages),
    mais utile pour le debug ou des chargements Ajax partiels.
    """
    queryset = Section.objects.filter(is_active=True)
    serializer_class = SectionModelSerializer
    permission_classes = [permissions.IsAuthenticatedOrReadOnly]