from django.contrib import admin
from django.db import models
from django_json_widget.widgets import JSONEditorWidget
from .models import Section

@admin.register(Section)
class SectionAdmin(admin.ModelAdmin):
    list_display = ('type', 'internal_name', 'page', 'order', 'is_active')
    list_filter = ('type', 'is_active', 'page')
    search_fields = ('internal_name', 'data')
    ordering = ('page', 'order')
    
    # Configuration du widget JSON pour un éditeur plus beau
    formfield_overrides = {
        models.JSONField: {'widget': JSONEditorWidget},
    }
    
    fieldsets = (
        ('Configuration', {
            'fields': ('page', 'type', 'internal_name', 'is_active', 'order')
        }),
        ('Contenu', {
            'description': "Le contenu doit respecter le format JSON du type sélectionné.",
            'fields': ('data',)
        }),
    )