from rest_framework import viewsets
from .models import Page
from .serializers import PageDetailSerializer, PageListSerializer

class PageViewSet(viewsets.ReadOnlyModelViewSet):
    """
    Endpoint principal du CMS.
    Lookup field = 'slug' pour accéder via /api/pages/mon-slug/
    """
    queryset = Page.objects.filter(is_published=True)
    lookup_field = 'slug'
    
    def get_serializer_class(self):
        if self.action == 'retrieve':
            return PageDetailSerializer
        return PageListSerializer