from django.db import migrations

def setup_listings(apps, schema_editor):
    Page = apps.get_model('pages', 'Page')
    Section = apps.get_model('sections', 'Section')

    # ==========================================
    # 1. CONFIGURATION PAGE PORTFOLIO
    # ==========================================
    # On la récupère ou on la crée si manquante
    page_portfolio, _ = Page.objects.get_or_create(
        slug='portfolio',
        defaults={
            'title': 'Nos Réalisations',
            'meta_description': 'Découvrez nos études de cas et projets récents.',
            'is_published': True
        }
    )
    
    # On nettoie pour être propre
    Section.objects.filter(page=page_portfolio).delete()

    # Section A : Hero
    Section.objects.create(
        page=page_portfolio, type='hero_simple', order=1, internal_name="Hero Portfolio",
        data={
            "title": "Nos Réalisations",
            "subtitle": "Des produits digitaux conçus pour durer et performer.",
            "background_color": "bg-primary"
        }
    )

    # Section B : La Grille Dynamique (C'est la magie !)
    Section.objects.create(
        page=page_portfolio, type='portfolio_grid', order=2, internal_name="Grille Projets",
        data={
            "count": 12,
            "show_filters": True,
            "title": "Sélection de projets"
        }
    )

    # Section C : CTA
    Section.objects.create(
        page=page_portfolio, type='cta', order=3, internal_name="CTA Bas",
        data={
            "title": "Un projet similaire ?",
            "text": "Nous serions ravis d'en discuter.",
            "btn_text": "Contactez-nous",
            "btn_url": "/contact"
        }
    )

    # ==========================================
    # 2. CONFIGURATION PAGE SERVICES
    # ==========================================
    # Note : Elle a été créée dans la migration 0002 sous le slug 'services'
    try:
        page_services = Page.objects.get(slug='services')
        
        # On nettoie
        Section.objects.filter(page=page_services).delete()

        # Section A : Hero
        Section.objects.create(
            page=page_services, type='hero_simple', order=1, internal_name="Hero Services",
            data={
                "title": "Nos Expertises",
                "subtitle": "Une couverture technique complète, du Backend au Frontend.",
            }
        )

        # Section B : Liste des Services (Connecteur)
        # Note : Le frontend utilisera ce bloc pour aller chercher les sous-pages "Service : ..."
        Section.objects.create(
            page=page_services, type='services_list', order=2, internal_name="Liste Services",
            data={
                "layout": "grid",
                "show_icons": True
            }
        )
        
        # Section C : Process (Pour enrichir la page)
        Section.objects.create(
            page=page_services, type='text_block', order=3, internal_name="Methodo",
            data={
                "align": "center",
                "content": "<h3>Notre Méthodologie</h3><p>Nous travaillons en méthode Agile pour garantir des livrables réguliers.</p>"
            }
        )

    except Page.DoesNotExist:
        pass # Ne devrait pas arriver

def reverse_setup(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0005_populate_about_page'), 
        ('sections', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(setup_listings, reverse_setup),
    ]