from django.db import migrations

def create_sub_pages(apps, schema_editor):
    Page = apps.get_model('pages', 'Page')

    sub_pages = [
        # --- SERVICES (Pages à structure unique) ---
        {
            "title": "Service : Développement Web",
            "slug": "services-developpement-web", # URL: /services-developpement-web
            "meta_description": "Sites vitrines, applications React/Next.js et architecture cloud.",
            "is_published": True,
        },
        {
            "title": "Service : Design UI/UX",
            "slug": "services-design-ui-ux",
            "meta_description": "Conception d'interfaces centrées utilisateur et design system.",
            "is_published": True,
        },
        {
            "title": "Service : Stratégie Digitale",
            "slug": "services-strategie",
            "meta_description": "Audit, SEO et accompagnement dans la transformation numérique.",
            "is_published": True,
        },

        # --- PROJETS PHARES (Traités comme des Pages pour un layout unique) ---
        {
            "title": "Projet : Redesign Nike (Concept)",
            "slug": "projet-nike-concept",
            "meta_description": "Étude de cas complète sur la refonte de l'expérience mobile.",
            "is_published": True,
        },
    ]

    for page_data in sub_pages:
        Page.objects.get_or_create(slug=page_data['slug'], defaults=page_data)

def reverse_create_sub_pages(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0002_create_default_pages'),
    ]

    operations = [
        migrations.RunPython(create_sub_pages, reverse_create_sub_pages),
    ]