from django.db import migrations

def create_pages(apps, schema_editor):
    """
    Crée les pages par défaut du site si elles n'existent pas.
    """
    # On récupère le modèle via apps.get_model pour éviter les problèmes d'import
    Page = apps.get_model('pages', 'Page')

    default_pages = [
        {
            "title": "Accueil",
            "slug": "accueil",
            "meta_description": "Bienvenue sur notre site vitrine. Découvrez nos solutions innovantes.",
            "is_published": True,
        },
        {
            "title": "À Propos",
            "slug": "a-propos",
            "meta_description": "Notre histoire, notre mission et nos valeurs.",
            "is_published": True,
        },
        {
            "title": "Nos Services",
            "slug": "services",
            "meta_description": "Explorez nos offres et expertises sur mesure.",
            "is_published": True,
        },
        {
            "title": "Blog",
            "slug": "blog",
            "meta_description": "Nos dernières actualités et articles de fond.",
            "is_published": True,
        },
        {
            "title": "Contact",
            "slug": "contact",
            "meta_description": "Contactez-nous pour démarrer votre projet.",
            "is_published": True,
        },
    ]

    for page_data in default_pages:
        # get_or_create permet d'éviter les doublons si on relance la migration
        Page.objects.get_or_create(slug=page_data['slug'], defaults=page_data)

def reverse_create_pages(apps, schema_editor):
    """
    Fonction inverse (si on annule la migration).
    On ne supprime RIEN par sécurité, car l'admin a pu ajouter du contenu entre temps.
    """
    pass

class Migration(migrations.Migration):

    dependencies = [
        # Cette migration doit s'exécuter APRES la création de la table Page
        ('pages', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_pages, reverse_create_pages),
    ]