from django.contrib import admin
from django.db import models
from adminsortable2.admin import SortableInlineAdminMixin
from django_json_widget.widgets import JSONEditorWidget

# Import croisé nécessaire : on importe le modèle Section depuis l'autre app
from apps.sections.models import Section
from .models import Page

class SectionInline(SortableInlineAdminMixin, admin.StackedInline):
    """
    Permet d'éditer les sections directement dans la page.
    - StackedInline : Affichage en blocs (mieux pour le JSON)
    - SortableInlineAdminMixin : Drag & drop pour l'ordre
    """
    model = Section
    extra = 0  # Pas de section vide par défaut
    fields = ('type', 'internal_name', 'is_active', 'data', 'order')
    
    # Utilisation du widget JSON amélioré
    formfield_overrides = {
        models.JSONField: {'widget': JSONEditorWidget},
    }

@admin.register(Page)
class PageAdmin(admin.ModelAdmin):
    list_display = ('title', 'slug', 'is_published', 'updated_at')
    list_filter = ('is_published', 'created_at')
    search_fields = ('title', 'slug')
    prepopulated_fields = {'slug': ('title',)}
    
    # C'est ici qu'on injecte les sections dans l'interface de la page
    inlines = [SectionInline]

    fieldsets = (
        ('Identification', {
            'fields': ('title', 'slug', 'is_published')
        }),
        ('SEO', {
            'fields': ('meta_description',),
            'classes': ('collapse',) # Masqué par défaut pour alléger
        }),
    )