from django.db import migrations

def create_menu_items(apps, schema_editor):
    # On charge les modèles nécessaires
    Menu = apps.get_model('navigation', 'Menu')
    MenuItem = apps.get_model('navigation', 'MenuItem')
    Page = apps.get_model('pages', 'Page')

    # 1. Récupération des Menus
    try:
        navbar = Menu.objects.get(slug='main_navbar')
        footer = Menu.objects.get(slug='footer_links')
        social = Menu.objects.get(slug='social_links')
    except Menu.DoesNotExist:
        return  # Sécurité si les menus n'ont pas été créés à l'étape d'avant

    # 2. Récupération des Pages (si elles existent)
    # On utilise filter().first() pour ne pas crasher si une page manque
    p_home = Page.objects.filter(slug='accueil').first()
    p_services = Page.objects.filter(slug='services').first()
    p_about = Page.objects.filter(slug='a-propos').first()
    p_blog = Page.objects.filter(slug='blog').first()
    p_contact = Page.objects.filter(slug='contact').first()

    # --- REMPLISSAGE DE LA NAVBAR ---
    if p_home:
        MenuItem.objects.create(menu=navbar, title="Accueil", page=p_home, order=1)
    
    if p_services:
        MenuItem.objects.create(menu=navbar, title="Expertise", page=p_services, order=2)
    
    if p_about:
        MenuItem.objects.create(menu=navbar, title="L'Agence", page=p_about, order=3)
    
    if p_blog:
        MenuItem.objects.create(menu=navbar, title="Journal", page=p_blog, order=4)
        
    if p_contact:
        MenuItem.objects.create(menu=navbar, title="Contact", page=p_contact, order=5)


    # --- REMPLISSAGE DU FOOTER ---
    # Liens rapides en bas de page
    if p_services:
        MenuItem.objects.create(menu=footer, title="Nos Services", page=p_services, order=1)
    
    if p_about:
        MenuItem.objects.create(menu=footer, title="À Propos", page=p_about, order=2)
        
    if p_contact:
        MenuItem.objects.create(menu=footer, title="Nous contacter", page=p_contact, order=3)
        

    # --- REMPLISSAGE DES RÉSEAUX SOCIAUX ---
    # Ici ce sont des liens externes (pas de Pages)
    MenuItem.objects.create(
        menu=social, 
        title="LinkedIn", 
        external_url="https://linkedin.com", 
        order=1
    )
    MenuItem.objects.create(
        menu=social, 
        title="Instagram", 
        external_url="https://instagram.com", 
        order=2
    )

def reverse_create_menu_items(apps, schema_editor):
    # En cas de retour arrière, on vide les items
    MenuItem = apps.get_model('navigation', 'MenuItem')
    MenuItem.objects.all().delete()

class Migration(migrations.Migration):

    dependencies = [
        ('navigation', '0002_create_default_menus'), # Dépend de la création des Menus
        ('pages', '0002_create_default_pages'),       # Dépend de la création des Pages
    ]

    operations = [
        migrations.RunPython(create_menu_items, reverse_create_menu_items),
    ]